Imports System.Collections

'
' Kiedy egzemplarz tej klasy otrzymuje sygna od fizycznego urzdzenia
' systemu ochrony, przekazuje odpowiednie powiadomienie do wszystkich
' zarejestrowanych obserwatorw.
'
Public Class SecurityNotifier
    Private observers As New ArrayList()

    ' Dodaje nowy obiekt obserwatora do wewntrznej kolekcji tego obiektu.
    Public Sub AddObserver(ByVal observer As SecurityObserver)
        observers.Add(observer)
    End Sub 'AddObserver

    ' Usuwa obiekt obserwatora z wewntrznej kolekcji tego obiektu.
    Public Sub RemoveObserver(ByVal observer As SecurityObserver)
        observers.Remove(observer)
    End Sub 'RemoveObserver

    '
    ' Metoda Notify jest wywoywana celem dostarczenia powiadomienia o zdarzeniu
    ' zwizanym z bezpieczestwem do tego obiektu.
    '
    ' d  Liczba liczba identyfikujca urzdzenie bdce oryginalnym rdem zdarzenia, ktre
    '     jest przedmiotem tego powiadomienia.
    ' e  Rodzaj rodzaj zdarzenia zwizanego z bezpieczestwem, ktrego wystpienie byo
    '     powodem wygenerowania tego powiadomienia.
    '
    Public Sub Notify(ByVal d As Integer, ByVal e As SecurityCondition)
        For Each ThisObserver As SecurityObserver In observers
            ThisObserver.Notify(d, e)
        Next
    End Sub
End Class 'SecurityNotifier
